/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.particles;

import com.alexander.mutantmore.particles.CirclingParticleOption;
import com.alexander.mutantmore.util.PositionUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HeatParticle<T extends CirclingParticleOption>
extends TextureSheetParticle {
    private float rollSpeed;
    private double circleRange;
    private float circleProgress;
    private float circleSpeed;
    private int followedEntityID;
    private double offsetXPosition;
    private double offsetYPosition;
    private double offsetZPosition;
    private Vec3 circleCentrePos;

    protected HeatParticle(ClientLevel level, double xCoord, double yCoord, double zCoord, SpriteSet spriteSet, double xd, double yd, double zd, T particleOptions) {
        super(level, xCoord, yCoord, zCoord, xd, yd, zd);
        this.circleRange = ((CirclingParticleOption)particleOptions).circleRange;
        this.circleProgress = ((CirclingParticleOption)particleOptions).circleProgress;
        this.circleSpeed = ((CirclingParticleOption)particleOptions).circleSpeed;
        this.followedEntityID = ((CirclingParticleOption)particleOptions).followedEntityID;
        this.offsetXPosition = ((CirclingParticleOption)particleOptions).offsetXPosition;
        this.offsetYPosition = ((CirclingParticleOption)particleOptions).offsetYPosition;
        this.offsetZPosition = ((CirclingParticleOption)particleOptions).offsetZPosition;
        this.rollSpeed = this.f_107223_.m_188501_() * 0.06f;
        this.f_172258_ = 0.8f;
        this.f_107663_ *= this.f_107223_.m_188501_() * 3.0f;
        this.f_107225_ = 20 + this.f_107223_.m_188503_(80);
        this.f_107230_ = 0.0f;
        this.m_108335_(spriteSet);
        this.circleCentrePos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
    }

    public int m_6355_(float p_106821_) {
        return 240;
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107212_ = this.circleCentrePos.f_82479_ + this.circleRange * (double)Mth.m_14089_((float)this.circleProgress);
        this.f_107213_ = this.circleCentrePos.f_82480_;
        this.f_107214_ = this.circleCentrePos.f_82481_ + this.circleRange * (double)Mth.m_14031_((float)this.circleProgress);
        this.m_107264_(this.f_107212_, this.f_107213_, this.f_107214_);
        this.circleProgress += this.circleSpeed;
        this.f_107231_ += this.rollSpeed;
        this.f_107204_ = this.f_107231_ + this.rollSpeed;
        this.f_107230_ = this.f_107224_ <= 2 ? 0.0f : 1.0f;
        if (this.followedEntityID != 0 && this.f_107208_.m_6815_(this.followedEntityID) != null) {
            Vec3 newPos;
            Entity entity = this.f_107208_.m_6815_(this.followedEntityID);
            float rotation = entity instanceof LivingEntity ? ((LivingEntity)entity).f_20883_ : entity.m_146908_();
            this.circleCentrePos = newPos = PositionUtils.getOffsetPos(entity, this.offsetXPosition, this.offsetYPosition, this.offsetZPosition, rotation);
        }
    }

    private void fadeOut() {
        this.f_107230_ = -(1.0f / (float)this.f_107225_) * (float)this.f_107224_ + 1.0f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<CirclingParticleOption> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(CirclingParticleOption particleOptions, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new HeatParticle<CirclingParticleOption>(level, x, y, z, this.sprites, dx, dy, dz, particleOptions);
        }
    }
}

